/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.StandardInfo;
import com.ibm.hwmca.base.logd.StandardLogDataBean;
import com.ibm.hwmca.base.logd.TextExpanderTasklet;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class StandardExpanderTasklet
extends TextExpanderTasklet
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDEST";
    private static final String TRACE_MASKD = "XLOGDESD";
    private static final String TRACE_MASKF = "XLOGDESF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String STANDARD_PANEL_NAME = "StandardLogDataPanel";
    private static final String REDIRECT_TASKLET = "com.ibm.hwmca.base.logd.DllExpanderTasklet";
    private CreateEventLogData _createEventLogData = new CreateEventLogData();
    private Log _logData;
    private DisplayerExpanderData displayExpanderData;
    private StandardInfo _standardInfo;
    private int PROGRAM_NAME_LENGTH = 51;
    private int USHORT_LEN = 2;
    private int INT_LEN = 4;
    private int CHAR_LEN = 1;
    private int VERSION_LEN = this.USHORT_LEN;
    private int INDEX_VERSION = 0;
    private int INDEX_PROGRAM_NAME = 0;
    private int INDEX_CURRENT_PROCESS_ID = 51;
    private int INDEX_PARENT_PROCESS_ID = 55;
    private int INDEX_CURRENT_THREAD_PRIORITY = 59;
    private int INDEX_CURRENT_THREAD_ID = 63;
    private int INDEX_SCREEN_GROUP = 67;
    private int INDEX_SUBSCREEN_GROUP = 71;
    private int INDEX_CURRENT_FOREGROUND_PROCESS = 75;
    private int INDEX_CURRENT_FOREGROUND_SCREEN_GROUP = 79;
    private int STANDARD_DATA_BLOCK_HMC_LEN = 80;
    private int STANDARD_DATA_BLOCK_SE_LEN = 91;
    private int STANDARD_DATA_BLOCK_HMC_WITH_VERSIONING_LEN = this.STANDARD_DATA_BLOCK_HMC_LEN + this.VERSION_LEN;
    private int STANDARD_DATA_BLOCK_SE_WITH_VERSIONING_LEN = this.STANDARD_DATA_BLOCK_SE_LEN + this.VERSION_LEN;
    private int EXPANDER_STD = 0;
    private int EXPANDER_TEXT = 1;
    private int EXPANDER_HEX = 2;
    private int EXPANDER_REDIRECT = 3;

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> StandardExpanderTasklet.service()");
        if (taskletRequest.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "StandardExpanderTasklet - doing InitialRequest");
            DisplayerExpanderData displayerExpanderData = super.retrieveExpanderData(taskletRequest, taskletResponse);
            if (!taskletResponse.isResponseSet() && displayerExpanderData != null) {
                byte[] hexData = displayerExpanderData.getHexData();
                Log log = displayerExpanderData.getLogData();
                LogBlock logBlock = displayerExpanderData.getLogBlock();
                if (hexData != null && hexData.length != 0) {
                    Trace.trace(TRACE_MASKF, "init  bean data for the standard displayer.");
                    boolean isVersioningSupported = log.isVersioningSupported();
                    int expander = this.whichExpander(isVersioningSupported, hexData);
                    if (expander == this.EXPANDER_STD) {
                        StandardInfo standardInfo = this.createStandardData(isVersioningSupported, log, hexData);
                        StandardLogDataBean standardLogDataBean = new StandardLogDataBean();
                        standardLogDataBean.setStandardInfo(standardInfo);
                        Trace.trace(TRACE_MASKF, "Display standard log data");
                        taskletResponse.openModalChild(AUIML_FILE_NAME, STANDARD_PANEL_NAME, standardLogDataBean);
                    } else if (expander == this.EXPANDER_TEXT) {
                        Trace.trace(TRACE_MASKF, "display standard data using text displayer.");
                        super.service(taskletRequest, taskletResponse);
                    } else if (expander == this.EXPANDER_REDIRECT) {
                        Trace.trace(TRACE_MASKF, "display standard data using old hardware block expander.");
                        HashMap<String, Cloneable> expanderData = new HashMap<String, Cloneable>();
                        expanderData.put("logObject", log);
                        expanderData.put("logBlockObject", logBlock);
                        taskletResponse.redirect(REDIRECT_TASKLET, null, this.getPresentationTaskParms(), expanderData);
                    } else {
                        Trace.trace(TRACE_MASKF, "display standard data using hex displayer.");
                        super.hexService(taskletRequest, taskletResponse);
                    }
                }
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            Trace.trace(TRACE_MASKF, "before the log terminate");
            taskletResponse.terminate();
        } else {
            String panelError = (String)taskletRequest.getData("panelError");
            if (panelError == null) {
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                String command = event.getActionCommand();
                String panelName = (String)taskletRequest.getData("panelName");
                Trace.trace(TRACE_MASKF, "StandardExpanderTasklet: Panel name=" + panelName);
                if (panelName.equals("HexPanel")) {
                    super.hexService(taskletRequest, taskletResponse);
                } else if (panelName.equals("TextPanel")) {
                    super.service(taskletRequest, taskletResponse);
                } else {
                    Trace.trace(TRACE_MASKF, "StandardExpander's command =" + command);
                    if (command.equals("OkButton")) {
                        taskletResponse.dispose();
                    } else if (command.equals("CANCEL")) {
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the StandardExpander panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "StandardExpanderTasklet panelErr=" + panelError);
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- StandardExpanderTasklet.service()");
    }

    private StandardInfo createStandardData(boolean isVersioningSupported, Log log, byte[] hexData) {
        StandardInfo standardInfo = new StandardInfo();
        int versionSize = 0;
        if (isVersioningSupported) {
            versionSize = this.VERSION_LEN;
            Trace.trace(TRACE_MASKF, "versioning in the log is supported");
            standardInfo.setVersion(HexString.toHex(ParserObj.toIntSwap(hexData, this.VERSION_LEN, this.INDEX_VERSION)).toUpperCase());
        }
        standardInfo.setProgramName(new String(hexData, versionSize + this.INDEX_PROGRAM_NAME, this.PROGRAM_NAME_LENGTH).trim());
        standardInfo.setCurrentProcessId(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_PROCESS_ID)).toUpperCase());
        standardInfo.setParentProcessId(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_PARENT_PROCESS_ID)).toUpperCase());
        standardInfo.setCurrentThreadPriority(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_THREAD_PRIORITY)).toUpperCase());
        standardInfo.setCurrentThreadId(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_THREAD_ID)).toUpperCase());
        standardInfo.setScreenGroup(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_SCREEN_GROUP)).toUpperCase());
        standardInfo.setSubScreenGroup(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_SUBSCREEN_GROUP)).toUpperCase());
        standardInfo.setCurrentForegroundProcess(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_FOREGROUND_PROCESS)).toUpperCase());
        byte currentForegroundScreenGroup = hexData[versionSize + this.INDEX_CURRENT_FOREGROUND_SCREEN_GROUP];
        standardInfo.setCurrentForegroundScreenGroup(HexString.toHex(currentForegroundScreenGroup, true));
        return standardInfo;
    }

    private int whichExpander(boolean isVersioningSupported, byte[] hexData) {
        int expander = this.EXPANDER_HEX;
        int hexDataLen = hexData.length;
        Trace.trace(TRACE_MASKF, "log(header)  isVersioningSupported flag=" + isVersioningSupported);
        Trace.trace(TRACE_MASKF, "Standard data length=" + hexDataLen);
        if (!isVersioningSupported) {
            if (hexDataLen == this.STANDARD_DATA_BLOCK_HMC_LEN) {
                expander = this.EXPANDER_STD;
            } else if (hexDataLen == this.STANDARD_DATA_BLOCK_SE_LEN) {
                expander = this.EXPANDER_REDIRECT;
            }
        } else {
            if (hexDataLen > this.VERSION_LEN) {
                int version = ParserObj.toIntSwap(hexData, this.VERSION_LEN, this.INDEX_VERSION);
                Trace.trace(TRACE_MASKF, "standard version flag=0x" + HexString.toHex(version));
                if (version == 1) {
                    if (hexDataLen == this.STANDARD_DATA_BLOCK_HMC_WITH_VERSIONING_LEN) {
                        expander = this.EXPANDER_STD;
                    } else if (hexDataLen == this.STANDARD_DATA_BLOCK_SE_WITH_VERSIONING_LEN) {
                        expander = this.EXPANDER_REDIRECT;
                    }
                } else if (version == 2) {
                    expander = this.EXPANDER_STD;
                }
            }
            Trace.trace(TRACE_MASKF, "expander to Display Standard Data=" + expander);
        }
        return expander;
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> StandardExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1365, e).log();
        Trace.trace(TRACE_MASKT, "<- StandardExpanderTasklet.logException()");
    }
}

